#ifndef __CRolloverButton__
#define __CRolloverButton__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CRolloverButton CRolloverButton.hpp
			 * @brief A rollover button with 3 states
			 * 
			 * A rollover button has 3 states:\n
			 * Mouse off (mouse not inside the area)\n
			 * Mover over (mouse inside area but not down)\n
			 * Mouse down (mouse inside area and down)\n
			 * And event is fired when the mouse has been down then released ie - It is a momentary button
			 *
			 * @date 28/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CRolloverButton.hpp,v 1.7 2007/02/08 21:07:54 paul Exp $
			 */
			class CRolloverButton : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * @enum ERolloverState
				 * @brief Rollover state enumerator
				 */
				enum ERolloverState
				{
					e_mouseOff = 0,			/**< Mouse is not within control */
					e_mouseOver,			/**< Mouse is over area */
					e_mouseDown,			/**< Mouse is clicked in area */
				};

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CRolloverButton(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CRolloverButton();

//	===========================================================================
				
				/**
				 * Should we use cursor change?
				 * @param use If true then when mouse over occurs mouse is changed to hand cursor
				 * @note Not recommended on mac, cos it looks messy!
				 */
				virtual void useCursorChange(const bool use = true) { m_cursorChange = use; }

//	===========================================================================

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle mouse leaving the area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

				/**
				 * Set the down image
				 * @param theImage The image to display when the mouse is down
				 */
				virtual void setDownImage(IImage *theImage);

				/**
				 * Set the over image
				 * @param theImage The image to display when the mouse is over
				 */
				virtual void setOverImage(IImage *theImage);

				/**
				 * Set the label text
				 * @param text The text to display on the button if there is no image
				 */
				void setLabelText(const CString &text) { m_labelText = text; }

//	===========================================================================

			protected:

//	===========================================================================

				IImage *m_downImage;		/**< The down image */
				IImage *m_overImage;		/**< The over image */
				ERolloverState m_state;		/**< The state */
				bool m_cursorChange;		/**< Should the cursor change */
				bool m_mouseIsDown;			/**< Is the mouse down? */
				CString m_labelText;		/**< Text drawn on the face of the button if no image is set */
			};
		}
	}
}
#endif	// End of CRolloverButton.hpp